using ComponentPro;

namespace AdvancedDemo.Samples.Template_and_Template_Class
{
    class Template_Class : TemplateExampleBase
    {
        /// <summary>
        /// Generates output from a template file.
        /// </summary>
        /// <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
        /// <param name="templateFile">The template file path.</param>
        /// <param name="templateSource">The template source loaded from the template file.</param>
        /// <returns>The generated output.</returns>
        public override string Generate(string templateSourceDirectory, string templateFile, string templateSource)
        {
            // Create a new instance of the TemplateEngine class.
            TemplateEngine dt = new TemplateEngine();

            // Load template content from a file.
            dt.LoadTemplateClassesFromFile(templateSourceDirectory + "\\BaseAndAbstract.tpc");
            dt.LoadTemplateClassesFromFile(templateSourceDirectory + "\\TheTemplateClass.tpc");
            dt.LoadFromString(templateSource);
            dt.SetValue("TemplateSourceDirectory", templateSourceDirectory);

            // Generate output.
            string output = dt.Run();

            return output;
        }
    }
}
